/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.velocity.tools.config.ValidScope;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.ValueParser;

@ValidScope(value={"application"})
public class ComparisonDateTool
extends DateTool {
    private static final long serialVersionUID = 6847034688404674662L;
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long MILLIS_PER_WEEK = 604800000L;
    public static final long MILLIS_PER_MONTH = 2592000000L;
    public static final long MILLIS_PER_YEAR = 31536000000L;
    public static final String BUNDLE_NAME_KEY = "bundle";
    public static final String DEPTH_KEY = "depth";
    public static final String SKIPPED_UNITS_KEY = "skip";
    public static final String DEFAULT_BUNDLE_NAME = "org.apache.velocity.tools.generic.times";
    protected static final String MILLISECOND_KEY = "millisecond";
    protected static final String SECOND_KEY = "second";
    protected static final String MINUTE_KEY = "minute";
    protected static final String HOUR_KEY = "hour";
    protected static final String DAY_KEY = "day";
    protected static final String WEEK_KEY = "week";
    protected static final String MONTH_KEY = "month";
    protected static final String YEAR_KEY = "year";
    protected static final Map TIME_UNITS;
    protected static final String CURRENT_PREFIX = "current.";
    protected static final String AFTER_KEY = "after";
    protected static final String BEFORE_KEY = "before";
    protected static final String EQUAL_KEY = "equal";
    protected static final String ZERO_KEY = "zero";
    protected static final String ABBR_SUFFIX = ".abbr";
    protected static final String ONE_DAY_SUFFIX = ".day";
    protected static final String PLURAL_SUFFIX = "s";
    protected static final int CURRENT_TYPE = 0;
    protected static final int RELATIVE_TYPE = 1;
    protected static final int DIFF_TYPE = 2;
    protected static final int EXACT_TYPE = 3;
    private String bundleName = "org.apache.velocity.tools.generic.times";
    private ResourceBundle defaultBundle;
    private Map<String, Long> timeUnits = TIME_UNITS;
    private int depth = 1;
    protected static final int[] CALENDAR_FIELDS;
    protected static final int[] FIELD_MAXIMA;
    protected static final String[] UNIT_KEYS;

    @Override
    protected void configure(ValueParser values) {
        super.configure(values);
        String bundle = values.getString(BUNDLE_NAME_KEY);
        if (bundle != null) {
            this.bundleName = bundle;
        }
        this.depth = values.getInt(DEPTH_KEY, 1);
        String[] skip = values.getStrings(SKIPPED_UNITS_KEY);
        if (skip != null) {
            this.timeUnits = new LinkedHashMap<String, Long>(TIME_UNITS);
            for (int i2 = 0; i2 < skip.length; ++i2) {
                this.timeUnits.remove(skip[i2]);
            }
        }
    }

    protected String getText(String key, Locale locale) {
        Locale defaultLocale = this.getLocale();
        ResourceBundle bundle = null;
        if (locale == null || locale.equals(defaultLocale)) {
            if (this.defaultBundle == null) {
                try {
                    this.defaultBundle = ResourceBundle.getBundle(this.bundleName, defaultLocale);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            bundle = this.defaultBundle;
        } else {
            try {
                bundle = ResourceBundle.getBundle(this.bundleName, locale);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return "???" + key + "???";
    }

    public static long toYears(long ms) {
        return ms / 31536000000L;
    }

    public static long toMonths(long ms) {
        return ms / 2592000000L;
    }

    public static long toWeeks(long ms) {
        return ms / 604800000L;
    }

    public static long toDays(long ms) {
        return ms / 86400000L;
    }

    public static long toHours(long ms) {
        return ms / 3600000L;
    }

    public static long toMinutes(long ms) {
        return ms / 60000L;
    }

    public static long toSeconds(long ms) {
        return ms / 1000L;
    }

    public Comparison whenIs(Object then) {
        return this.compare(this.getCalendar(), then, 0);
    }

    public Comparison whenIs(Object now, Object then) {
        return this.compare(now, then, 1);
    }

    public Comparison difference(Object now, Object then) {
        return this.compare(now, then, 2);
    }

    public Comparison timespan(Object now, Object then) {
        return this.compare(now, then, 3);
    }

    protected Comparison compare(Object now, Object then, int type) {
        Calendar calThen = this.toCalendar(then);
        Calendar calNow = this.toCalendar(now);
        if (calThen == null || calNow == null) {
            this.getLog().warn("cannot compare date objects {} and {}", (Object)(now == null ? "null" : now.getClass().getName()), (Object)(then == null ? "null" : then.getClass().getName()));
            return null;
        }
        return new Comparison(calNow, calThen, type, this.depth, false, null);
    }

    static {
        LinkedHashMap<String, Long> units = new LinkedHashMap<String, Long>(8);
        units.put(MILLISECOND_KEY, 1L);
        units.put(SECOND_KEY, 1000L);
        units.put(MINUTE_KEY, 60000L);
        units.put(HOUR_KEY, 3600000L);
        units.put(DAY_KEY, 86400000L);
        units.put(WEEK_KEY, 604800000L);
        units.put(MONTH_KEY, 2592000000L);
        units.put(YEAR_KEY, 31536000000L);
        TIME_UNITS = Collections.unmodifiableMap(units);
        CALENDAR_FIELDS = new int[]{1, 2, 5, 11, 12, 13, 14};
        FIELD_MAXIMA = new int[]{0, 12, 0, 24, 60, 60, 1000};
        UNIT_KEYS = new String[]{YEAR_KEY, MONTH_KEY, DAY_KEY, HOUR_KEY, MINUTE_KEY, SECOND_KEY, MILLISECOND_KEY};
    }

    public class Comparison {
        private final Calendar now;
        private final Calendar then;
        private final long milliseconds;
        private int[] exactDifference = null;
        private final int type;
        private final int maxUnitDepth;
        private final boolean abbreviate;
        private final Locale locale;

        public Comparison(Calendar now, Calendar then, int type, int depth, boolean abbr, Locale loc) {
            this.now = now;
            this.then = then;
            this.milliseconds = then.getTimeInMillis() - now.getTimeInMillis();
            this.type = type;
            this.maxUnitDepth = depth;
            this.abbreviate = abbr;
            this.locale = loc;
        }

        public Comparison abbr(boolean abbr) {
            return new Comparison(this.now, this.then, this.type, this.maxUnitDepth, abbr, this.locale);
        }

        public Comparison depth(int depth) {
            return new Comparison(this.now, this.then, this.type, depth, this.abbreviate, this.locale);
        }

        public Comparison locale(Locale loc) {
            return new Comparison(this.now, this.then, this.type, this.maxUnitDepth, this.abbreviate, loc);
        }

        protected final int[] getExactDifference() {
            if (this.exactDifference == null) {
                this.exactDifference = new int[CALENDAR_FIELDS.length];
                Calendar from = this.now;
                Calendar to = this.then;
                if (this.milliseconds < 0L) {
                    from = this.then;
                    to = this.now;
                }
                int[] maxima = Arrays.copyOf(FIELD_MAXIMA, FIELD_MAXIMA.length);
                Calendar tmp = (Calendar)to.clone();
                tmp.add(2, -1);
                maxima[2] = tmp.getActualMaximum(5);
                int carry = 0;
                int i2 = CALENDAR_FIELDS.length;
                while (i2-- > 1) {
                    int start = from.get(CALENDAR_FIELDS[i2]);
                    int end = to.get(CALENDAR_FIELDS[i2]);
                    int diff = end - (start + carry);
                    if (diff < 0) {
                        diff += maxima[i2];
                        carry = 1;
                    } else {
                        carry = 0;
                    }
                    this.exactDifference[i2] = diff;
                }
                this.exactDifference[0] = to.get(1) - (from.get(1) + carry);
            }
            return this.exactDifference;
        }

        public long getYears() {
            return this.type == 3 ? (long)this.getExactDifference()[0] : ComparisonDateTool.toYears(this.milliseconds);
        }

        public long getMonths() {
            return this.type == 3 ? (long)this.getExactDifference()[1] : ComparisonDateTool.toMonths(this.milliseconds);
        }

        public long getWeeks() {
            if (this.type == 3) {
                ComparisonDateTool.this.getLog().warn("Requesting weeks difference in exact mode still returns the totall relative number of weeks");
            }
            return ComparisonDateTool.toWeeks(this.milliseconds);
        }

        public long getDays() {
            return this.type == 3 ? (long)this.getExactDifference()[2] : ComparisonDateTool.toDays(this.milliseconds);
        }

        public long getHours() {
            return this.type == 3 ? (long)this.getExactDifference()[3] : ComparisonDateTool.toHours(this.milliseconds);
        }

        public long getMinutes() {
            return this.type == 3 ? (long)this.getExactDifference()[4] : ComparisonDateTool.toMinutes(this.milliseconds);
        }

        public long getSeconds() {
            return this.type == 3 ? (long)this.getExactDifference()[5] : ComparisonDateTool.toSeconds(this.milliseconds);
        }

        public long getMilliseconds() {
            return this.type == 3 ? (long)this.getExactDifference()[6] : this.milliseconds;
        }

        public Comparison getFull() {
            return this.depth(ComparisonDateTool.this.timeUnits.size());
        }

        public Comparison getDifference() {
            return new Comparison(this.now, this.then, 2, this.maxUnitDepth, this.abbreviate, this.locale);
        }

        public Comparison getRelative() {
            return new Comparison(this.now, this.then, 1, this.maxUnitDepth, this.abbreviate, this.locale);
        }

        public Comparison getExact() {
            return new Comparison(this.now, this.then, 1, this.maxUnitDepth, this.abbreviate, this.locale);
        }

        public Comparison getAbbr() {
            return this.abbr(true);
        }

        protected String toString(long diff, int maxUnitDepth) {
            long value = 0L;
            long remainder = 0L;
            String unitKey = null;
            if (maxUnitDepth > ComparisonDateTool.this.timeUnits.size()) {
                maxUnitDepth = ComparisonDateTool.this.timeUnits.size();
            }
            if (this.type == 3) {
                for (remainder = diff; remainder < (long)CALENDAR_FIELDS.length; ++remainder) {
                    long val = this.getExactDifference()[(int)remainder];
                    if (value == 0L) {
                        value = val;
                        unitKey = UNIT_KEYS[(int)remainder];
                        continue;
                    }
                    if (val > 0L) break;
                }
                remainder %= (long)CALENDAR_FIELDS.length;
                if (value == 0L) {
                    return null;
                }
            } else {
                if (diff <= 0L) {
                    return null;
                }
                Iterator i2 = ComparisonDateTool.this.timeUnits.keySet().iterator();
                unitKey = (String)i2.next();
                long unit = (Long)ComparisonDateTool.this.timeUnits.get(unitKey);
                while (i2.hasNext()) {
                    String nextUnitKey = (String)i2.next();
                    long nextUnit = (Long)ComparisonDateTool.this.timeUnits.get(nextUnitKey);
                    if (diff < nextUnit) {
                        value = diff / unit;
                        remainder = diff % unit;
                        break;
                    }
                    unitKey = nextUnitKey;
                    unit = nextUnit;
                }
                if (unitKey.equals(ComparisonDateTool.YEAR_KEY)) {
                    value = diff / unit;
                    remainder = diff % unit;
                }
            }
            if (value != 1L) {
                unitKey = unitKey + ComparisonDateTool.PLURAL_SUFFIX;
            }
            if (this.abbreviate) {
                unitKey = unitKey + ComparisonDateTool.ABBR_SUFFIX;
            }
            String output = value + " " + ComparisonDateTool.this.getText(unitKey, this.locale);
            if (maxUnitDepth > 1 && remainder > 0L) {
                output = output + " " + this.toString(remainder, maxUnitDepth - 1);
            }
            return output;
        }

        public String toString() {
            String directionKey;
            long ms = this.milliseconds;
            if (ms == 0L) {
                String sameKey;
                String string = sameKey = this.abbreviate ? ComparisonDateTool.ABBR_SUFFIX : "";
                sameKey = this.type == 0 ? "current.equal" + sameKey : (this.type == 1 ? ComparisonDateTool.EQUAL_KEY + sameKey : ComparisonDateTool.ZERO_KEY + sameKey);
                return ComparisonDateTool.this.getText(sameKey, this.locale);
            }
            boolean isBefore = false;
            if (ms < 0L) {
                isBefore = true;
                ms *= -1L;
            }
            String friendly = this.toString(this.type == 3 ? 0L : ms, ComparisonDateTool.this.depth);
            if (this.type == 2) {
                if (isBefore) {
                    friendly = "-" + friendly;
                }
                return friendly;
            }
            String string = directionKey = isBefore ? ComparisonDateTool.BEFORE_KEY : ComparisonDateTool.AFTER_KEY;
            if (this.type == 0) {
                directionKey = ComparisonDateTool.CURRENT_PREFIX + directionKey;
                if (friendly != null && friendly.startsWith("1")) {
                    String dayKey;
                    String string2 = dayKey = this.abbreviate ? "day.abbr" : ComparisonDateTool.DAY_KEY;
                    if (friendly.equals("1 " + ComparisonDateTool.this.getText(dayKey, this.locale))) {
                        directionKey = directionKey + ComparisonDateTool.ONE_DAY_SUFFIX;
                        return ComparisonDateTool.this.getText(directionKey, this.locale);
                    }
                }
            }
            if (this.abbreviate) {
                directionKey = directionKey + ComparisonDateTool.ABBR_SUFFIX;
            }
            return friendly + " " + ComparisonDateTool.this.getText(directionKey, this.locale);
        }
    }
}

