/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.command.diff;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.util.AbstractConsumer;

public class SvnDiffConsumer
extends AbstractConsumer {
    private static final String INDEX_TOKEN = "Index: ";
    private static final String FILE_SEPARATOR_TOKEN = "===";
    private static final String START_REVISION_TOKEN = "---";
    private static final String END_REVISION_TOKEN = "+++";
    private static final String ADDED_LINE_TOKEN = "+";
    private static final String REMOVED_LINE_TOKEN = "-";
    private static final String UNCHANGED_LINE_TOKEN = " ";
    private static final String CHANGE_SEPARATOR_TOKEN = "@@";
    private static final String NO_NEWLINE_TOKEN = "\\ No newline at end of file";
    private String currentFile;
    private StringBuilder currentDifference;
    private final List<ScmFile> changedFiles = new ArrayList<ScmFile>();
    private final Map<String, CharSequence> differences = new HashMap<String, CharSequence>();
    private final StringBuilder patch = new StringBuilder();

    public SvnDiffConsumer(File workingDirectory) {
    }

    @Override
    public void consumeLine(String line) {
        if (line.startsWith(INDEX_TOKEN)) {
            this.currentFile = line.substring(INDEX_TOKEN.length());
            this.changedFiles.add(new ScmFile(this.currentFile, ScmFileStatus.MODIFIED));
            this.currentDifference = new StringBuilder();
            this.differences.put(this.currentFile, this.currentDifference);
            this.patch.append(line).append("\n");
            return;
        }
        if (this.currentFile == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Unparseable line: '" + line + "'");
            }
            this.patch.append(line).append("\n");
            return;
        }
        if (line.startsWith(FILE_SEPARATOR_TOKEN)) {
            this.patch.append(line).append("\n");
        } else if (line.startsWith(START_REVISION_TOKEN)) {
            this.patch.append(line).append("\n");
        } else if (line.startsWith(END_REVISION_TOKEN)) {
            this.patch.append(line).append("\n");
        } else if (line.startsWith(ADDED_LINE_TOKEN) || line.startsWith(REMOVED_LINE_TOKEN) || line.startsWith(UNCHANGED_LINE_TOKEN) || line.startsWith(CHANGE_SEPARATOR_TOKEN) || line.equals(NO_NEWLINE_TOKEN)) {
            this.currentDifference.append(line).append("\n");
            this.patch.append(line).append("\n");
        } else {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Unparseable line: '" + line + "'");
            }
            this.patch.append(line).append("\n");
            this.currentFile = null;
            this.currentDifference = null;
        }
    }

    public List<ScmFile> getChangedFiles() {
        return this.changedFiles;
    }

    public Map<String, CharSequence> getDifferences() {
        return this.differences;
    }

    public String getPatch() {
        return this.patch.toString();
    }
}

