/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport.imap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.transport.AuthenticationProxy;
import net.messagevortex.transport.ListeningSocketChannel;
import net.messagevortex.transport.SecurityContext;
import net.messagevortex.transport.SecurityRequirement;
import net.messagevortex.transport.ServerConnection;
import net.messagevortex.transport.SocketListener;
import net.messagevortex.transport.StoppableThread;
import net.messagevortex.transport.imap.ImapConnection;

public class ImapServer
extends ListeningSocketChannel
implements StoppableThread,
SocketListener {
    private static final Logger LOGGER;
    private static int id;
    private long gcLastRun = 0L;
    private final Set<ImapConnection> connSet = new ConcurrentSkipListSet<ImapConnection>();
    private AuthenticationProxy auth = null;
    private static final long defaultTimeout = 10000L;
    private long timeout = 10000L;

    public ImapServer(SecurityContext secContext) throws IOException {
        super(new InetSocketAddress(InetAddress.getByAddress(new byte[]{0, 0, 0, 0}), secContext.getRequirement() == SecurityRequirement.UNTRUSTED_SSLTLS || secContext.getRequirement() == SecurityRequirement.SSLTLS ? 993 : 143), null);
        this.setSocketListener(this);
        this.setSecurityContext(secContext);
        this.setProtocol("imap");
        this.setName("IMAPlisten-" + id++);
    }

    public ImapServer(InetSocketAddress addr, SecurityContext enc) throws IOException {
        super(addr, null);
        this.setSocketListener(this);
        this.setSecurityContext(enc);
        this.setProtocol("imap");
        this.setName("IMAPlisten-" + id++);
    }

    public AuthenticationProxy setAuth(AuthenticationProxy ap) {
        AuthenticationProxy old = this.auth;
        this.auth = ap;
        return old;
    }

    @Override
    public void gotConnect(ServerConnection ac) {
        this.doGarbageCollection(false);
        LOGGER.log(Level.INFO, "got new connection");
        ImapConnection ic = new ImapConnection(ac, this.auth);
        ic.setTimeout(this.getTimeout());
        this.connSet.add(ic);
        LOGGER.log(Level.INFO, "inbound connection ready for use");
    }

    private void doGarbageCollection(boolean force) {
        if (force || this.gcLastRun + 10000L < System.currentTimeMillis()) {
            LOGGER.log(Level.INFO, "Running garbage collector for connections");
            HashSet<ImapConnection> tmp = new HashSet<ImapConnection>();
            for (ImapConnection ic : this.connSet) {
                if (!ic.isShutdown()) continue;
                tmp.add(ic);
            }
            this.connSet.removeAll(tmp);
            LOGGER.log(Level.INFO, "garbage collector removed " + tmp.size() + " connections (" + this.connSet.size() + " remaining)");
            this.gcLastRun = System.currentTimeMillis();
        }
    }

    @Override
    public boolean isShutdown() {
        this.doGarbageCollection(true);
        return super.isShutdown() && this.connSet.size() == 0;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.doGarbageCollection(true);
        for (ImapConnection ic : this.connSet) {
            ic.shutdown();
        }
        this.doGarbageCollection(true);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long setTimeout(long timeout) {
        long ret = this.timeout;
        this.timeout = timeout;
        return ret;
    }

    static {
        id = 1;
        LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    }
}

