/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import net.messagevortex.asn1.AbstractBlock;
import net.messagevortex.asn1.AsymmetricKey;
import net.messagevortex.asn1.Dumpable;
import net.messagevortex.asn1.HeaderRequest;
import net.messagevortex.asn1.HeaderRequestFactory;
import net.messagevortex.asn1.MacAlgorithm;
import net.messagevortex.asn1.SymmetricKey;
import net.messagevortex.asn1.UsagePeriod;
import net.messagevortex.asn1.encryption.Algorithm;
import net.messagevortex.asn1.encryption.AlgorithmType;
import net.messagevortex.asn1.encryption.DumpType;
import net.messagevortex.asn1.encryption.SecurityLevel;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class IdentityBlock
extends AbstractBlock
implements Serializable,
Dumpable {
    public static final long serialVersionUID = 100000000008L;
    private static int nextID = 0;
    private static final Object nextIdSemaphore = new Object();
    private static final int ENCRYPTED_HEADER_KEY = 1000;
    private static final int ENCRYPTED_BLOCK = 1001;
    private static final int PLAIN_BLOCK = 1002;
    private static final int ENCRYPTED_HEADER = 1101;
    private static final HeaderRequest[] NULLREQUESTS = new HeaderRequest[0];
    private SymmetricKey headerKey;
    private byte[] encryptedHeaderKey = null;
    private AsymmetricKey identityKey = null;
    private long serial;
    private int maxReplays;
    private UsagePeriod valid = null;
    private int forwardSecret = -1;
    private MacAlgorithm hash = new MacAlgorithm(Algorithm.getDefault(AlgorithmType.HASHING));
    private HeaderRequest[] requests;
    private long identifier = -1L;
    private byte[] padding = null;
    private byte[] encryptedIdentityBlock = null;
    private final IdentityStatus status = IdentityStatus.NEW;
    private final int id;
    private AsymmetricKey ownIdentity = null;

    public IdentityBlock() throws IOException {
        this(new AsymmetricKey(Algorithm.getDefault(AlgorithmType.ASYMMETRIC).getParameters(SecurityLevel.MEDIUM)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentityBlock(AsymmetricKey key) throws IOException {
        this.identityKey = key;
        this.serial = (long)(Math.random() * 4.294967295E9);
        this.maxReplays = 1;
        this.valid = new UsagePeriod(3600L);
        this.requests = NULLREQUESTS;
        Object object = nextIdSemaphore;
        synchronized (object) {
            this.id = nextID++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentityBlock(byte[] b, AsymmetricKey ownIdentity) throws IOException {
        this.ownIdentity = ownIdentity;
        ASN1Sequence s = ASN1Sequence.getInstance(b);
        Object object = nextIdSemaphore;
        synchronized (object) {
            this.id = nextID++;
        }
        this.parse(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentityBlock(byte[] b) throws IOException {
        ASN1Sequence s = ASN1Sequence.getInstance(b);
        Object object = nextIdSemaphore;
        synchronized (object) {
            this.id = nextID++;
        }
        this.parse(s);
    }

    public IdentityBlock(ASN1Encodable to) throws IOException {
        this(to, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentityBlock(ASN1Encodable to, AsymmetricKey ownIdentity) throws IOException {
        this.ownIdentity = ownIdentity;
        this.parse(to);
        Object object = nextIdSemaphore;
        synchronized (object) {
            this.id = nextID++;
        }
    }

    public void setRequests(HeaderRequest[] hr) {
        this.requests = Arrays.copyOf(hr, hr.length);
    }

    @Override
    protected final void parse(ASN1Encodable o) throws IOException {
        byte[] signature;
        ASN1TaggedObject to;
        ASN1Sequence s = ASN1Sequence.getInstance(o);
        int j = 0;
        if ((to = ASN1TaggedObject.getInstance(s.getObjectAt(j++))).getTagNo() == 1000) {
            if (this.ownIdentity == null) {
                this.encryptedHeaderKey = IdentityBlock.toDer(to.getBaseObject());
                to = DERTaggedObject.getInstance(s.getObjectAt(j++));
            } else {
                this.headerKey = new SymmetricKey(this.ownIdentity.decrypt(IdentityBlock.toDer(to.getBaseObject())));
                to = DERTaggedObject.getInstance(s.getObjectAt(j++));
            }
        }
        byte[] signVerifyObject = IdentityBlock.toDer(to.getBaseObject());
        if (this.headerKey != null && to.getTagNo() == 1101 || to.getTagNo() == 1002) {
            ASN1Sequence s1 = this.headerKey != null && to.getTagNo() == 1001 ? ASN1Sequence.getInstance(this.headerKey.decrypt(IdentityBlock.toDer(to.getBaseObject()))) : ASN1Sequence.getInstance(to.getBaseObject());
            int i2 = 0;
            ASN1Encodable s3 = s1.getObjectAt(i2++);
            this.identityKey = new AsymmetricKey(IdentityBlock.toDer(s3.toASN1Primitive()));
            this.serial = ASN1Integer.getInstance(s1.getObjectAt(i2++)).getValue().longValue();
            this.maxReplays = ASN1Integer.getInstance(s1.getObjectAt(i2++)).getValue().intValue();
            this.valid = new UsagePeriod(s1.getObjectAt(i2++));
            this.forwardSecret = ASN1Integer.getInstance(s1.getObjectAt(i2++)).getValue().intValue();
            this.hash = new MacAlgorithm(s1.getObjectAt(i2++));
            ASN1Sequence s2 = ASN1Sequence.getInstance(s1.getObjectAt(i2++));
            this.requests = new HeaderRequest[s2.size()];
            for (int y = 0; y < s2.size(); ++y) {
                this.requests[y] = HeaderRequestFactory.getInstance(s2.getObjectAt(y));
            }
            while (s1.size() > i2) {
                if ((to = ASN1TaggedObject.getInstance(s1.getObjectAt(i2++))).getTagNo() == 1) {
                    this.identifier = ASN1Integer.getInstance(to.getBaseObject()).getValue().longValue();
                    continue;
                }
                if (to.getTagNo() != 2) continue;
                this.padding = ASN1OctetString.getInstance(s1.getObjectAt(i2)).getOctets();
            }
        } else {
            this.encryptedIdentityBlock = IdentityBlock.toDer(to.getBaseObject());
        }
        if (!this.identityKey.verify(signVerifyObject, signature = ASN1OctetString.getInstance(s.getObjectAt(j++)).getOctets(), this.hash.getAlgorithm())) {
            throw new IOException("Exception while verifying signature of identity block");
        }
    }

    public int getReplay() {
        return this.maxReplays;
    }

    public int setReplay(int maxReplay) {
        int old = this.getReplay();
        this.maxReplays = maxReplay;
        return old;
    }

    public UsagePeriod getUsagePeriod() {
        return new UsagePeriod(this.valid);
    }

    public UsagePeriod setUsagePeriod(UsagePeriod valid) {
        UsagePeriod old = this.getUsagePeriod();
        this.valid = new UsagePeriod(valid);
        return old;
    }

    public AsymmetricKey getOwnIdentity() {
        return this.ownIdentity;
    }

    public AsymmetricKey setOwnIdentity(AsymmetricKey oid) {
        AsymmetricKey old = this.ownIdentity;
        this.ownIdentity = oid;
        return old;
    }

    public AsymmetricKey getIdentityKey() {
        if (this.identityKey == null) {
            return null;
        }
        return new AsymmetricKey(this.identityKey);
    }

    public AsymmetricKey setIdentityKey(AsymmetricKey oid) {
        AsymmetricKey old = this.identityKey;
        this.identityKey = oid;
        return old;
    }

    private void sanitizeHeaderKey() throws IOException {
        if (this.headerKey == null && this.encryptedHeaderKey == null) {
            this.headerKey = new SymmetricKey();
        }
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) throws IOException {
        return this.toAsn1Object(dumpType, null);
    }

    public ASN1Object toAsn1Object(DumpType dumpType, AsymmetricKey targetIdentity) throws IOException {
        ASN1Primitive o;
        ASN1Primitive ae;
        this.sanitizeHeaderKey();
        if (this.headerKey == null && this.encryptedHeaderKey == null) {
            throw new NullPointerException("headerKey may not be null");
        }
        ASN1EncodableVector v1 = new ASN1EncodableVector();
        boolean encryptIdentity = false;
        if (this.headerKey != null && targetIdentity != null) {
            v1.add(new DERTaggedObject(true, 1000, (ASN1Encodable)new DEROctetString(targetIdentity.encrypt(this.headerKey.toBytes(dumpType)))));
            encryptIdentity = true;
        } else if (this.encryptedHeaderKey != null) {
            v1.add(new DERTaggedObject(true, 1000, (ASN1Encodable)new DEROctetString(this.encryptedHeaderKey)));
            encryptIdentity = true;
        }
        if (this.encryptedIdentityBlock != null) {
            ae = new DEROctetString(this.encryptedIdentityBlock);
        } else {
            ASN1EncodableVector v = new ASN1EncodableVector();
            ASN1Object o2 = this.identityKey.toAsn1Object(DumpType.ALL);
            if (o2 == null) {
                throw new IOException("identityKey did return null object");
            }
            v.add(o2);
            v.add(new ASN1Integer(this.serial));
            v.add(new ASN1Integer(this.maxReplays));
            o2 = this.valid.toAsn1Object(dumpType);
            if (o2 == null) {
                throw new IOException("validity did return null object");
            }
            v.add(o2);
            v.add(new ASN1Integer(this.forwardSecret));
            v.add(this.hash.toAsn1Object(dumpType));
            ASN1EncodableVector s = new ASN1EncodableVector();
            for (HeaderRequest r : this.requests) {
                s.add(r.toAsn1Object(dumpType));
            }
            v.add(new DERSequence(s));
            if (this.identifier > -1L) {
                v.add(new DERTaggedObject(true, 1, (ASN1Encodable)new ASN1Integer(this.identifier)));
            }
            if (this.padding != null) {
                v.add(new DERTaggedObject(true, 2, (ASN1Encodable)new DEROctetString(this.padding)));
            }
            ae = new DERSequence(v);
        }
        if (encryptIdentity) {
            if (this.headerKey == null) {
                throw new IOException("header key is empty but block should be encrypted");
            }
            o = new DEROctetString(this.headerKey.encrypt(IdentityBlock.toDer(ae.toASN1Primitive())));
            v1.add(new DERTaggedObject(true, 1001, (ASN1Encodable)o));
        } else {
            o = ae.toASN1Primitive();
            v1.add(new DERTaggedObject(true, 1002, (ASN1Encodable)o));
        }
        v1.add(new DEROctetString(this.identityKey.sign(IdentityBlock.toDer(o))));
        return new DERSequence(v1);
    }

    public String dumpValueNotation(String prefix) throws IOException {
        return this.dumpValueNotation(prefix, DumpType.PUBLIC_ONLY);
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumpType) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("{\r\n");
        if (this.encryptedHeaderKey != null) {
            sb.append(prefix).append("  headerKey ").append(IdentityBlock.toHex(this.encryptedHeaderKey));
        }
        if (this.encryptedIdentityBlock != null) {
            sb.append(prefix).append("  blocks encrypted ").append(IdentityBlock.toHex(this.encryptedIdentityBlock));
        } else {
            sb.append(prefix).append("  blocks plain {").append("\r\n");
            sb.append(prefix).append("    identityKey ").append(this.identityKey.dumpValueNotation(prefix + "  ", DumpType.PRIVATE_COMMENTED)).append(',').append("\r\n");
            sb.append(prefix).append("    serial ").append(this.serial).append(',').append("\r\n");
            sb.append(prefix).append("    maxReplays ").append(this.maxReplays).append(',').append("\r\n");
            sb.append(prefix).append("    valid ").append(this.valid.dumpValueNotation(prefix + "  ", dumpType)).append(',').append("\r\n");
            sb.append(prefix).append("    forwardSecret ").append(this.forwardSecret).append("\r\n");
            sb.append(prefix).append("    decryptionKey ''B,").append("\r\n");
            sb.append(prefix).append("    requests {").append("\r\n");
            for (HeaderRequest r : this.requests) {
                sb.append(this.valid.dumpValueNotation(prefix + "  ", dumpType)).append("\r\n");
                sb.append(r.dumpValueNotation(prefix + "  ", dumpType)).append("\r\n");
            }
            sb.append(prefix).append("    }");
            if (this.padding != null) {
                sb.append(',').append("\r\n");
                sb.append(prefix).append("    padding ").append(IdentityBlock.toHex(this.padding)).append("\r\n");
            } else {
                sb.append("\r\n");
            }
            sb.append(prefix).append("  },");
        }
        sb.append(prefix).append('}');
        return sb.toString();
    }

    public long getSerial() {
        return this.serial;
    }

    public long setSerial(long serial) {
        long ret = this.getSerial();
        this.serial = serial;
        return ret;
    }

    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        if (t.getClass() != this.getClass()) {
            return false;
        }
        IdentityBlock o = (IdentityBlock)t;
        try {
            return this.dumpValueNotation("", DumpType.ALL_UNENCRYPTED).equals(o.dumpValueNotation("", DumpType.ALL_UNENCRYPTED));
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.dumpValueNotation("", DumpType.ALL).hashCode();
        }
        catch (IOException ioe) {
            return "FAILED".hashCode();
        }
    }

    public String toString() {
        return "Identity" + this.id;
    }

    public static enum IdentityStatus {
        NEW(0),
        PUZZLE_REQUESTED(1),
        PUZZLE_RECEIVED(2),
        PUZZLE_SENT(3),
        ESTABLISHED(10),
        EXPIRED(100);

        private final int statusNumber;

        private IdentityStatus(int num) {
            this.statusNumber = num;
        }

        public int getStatusNumber() {
            return this.statusNumber;
        }
    }
}

